ORCA/M Asm65816 2.1.0

0001 F4A8                       TITLE ', STRUCT.a - Add_Link'
0002 F4A8              *
0003 F4A8              ****************************************************************
0004 F4A8              *
0005 F4A8              *        Add entry to Linked List
0006 F4A8              *
0007 F4A8              *        Each entry in a Linked List starts with two 4 byte Handles.
0008 F4A8              *        The first is a handle to the next entry
0009 F4A8              *        and the second is a handle to the previous entry.
0010 F4A8              *
0011 F4A8              *  Inputs:     Address of Linked List (TOS+7)
0012 F4A8              *              Handle to New   Entry  (TOS+3)
0013 F4A8              *  Outputs:    none
0014 F4A8              *
0015 F4A8              ****************************************************************
0016 F4A8              *
0017 F4A8
0018 F4A8              Add_Link PROC 
0019 F4A8                       with DirectPage
0020 F4A8
0021 F4A8              First_Entry equ   7
0022 F4A8              New_Entry equ   3
0023 F4A8              ;
0024 F4A8              ;        check whether this is 1st entry in Linked List
0025 F4A8              ;
0026 F4A8 A0 00 00              ldy   #0
0027 F4AB B3 07                 lda   (First_Entry,s),y
0028 F4AD A0 02 00              ldy   #2
0029 F4B0 13 07                 ora   (First_Entry,s),y
0030 F4B2 D0 0D                 bne   cont
0031 F4B4              ;
0032 F4B4              ;        this is first entry, store handle of new entry in input
0033 F4B4              ;        address of Linked List (address assumed to be in same bank
0034 F4B4              ;        as this code)
0035 F4B4              ;
0036 F4B4 A3 05                 lda   New_Entry+2,s
0037 F4B6 93 07                 sta   (First_Entry,s),y        ;Y is still == 2
0038 F4B8 A3 03                 lda   New_Entry,s
0039 F4BA A0 00 00              ldy   #0
0040 F4BD 93 07                 sta   (First_Entry,s),y
0041 F4BF 80 51                 bra   done                     ;done
0042 F4C1              ;
0043 F4C1              ;        this is not first entry, replace address of Linked List with
0044 F4C1              ;        Handle to First Entry
0045 F4C1              ;
0046 F4C1 B3 07        cont     lda   (First_Entry,s),y        ;Y == 2 here
0047 F4C3 83 09                 sta   First_Entry+2,s
0048 F4C5 A0 00 00              ldy   #0
0049 F4C8 B3 07                 lda   (First_Entry,s),y
0050 F4CA 83 07                 sta   First_Entry,s
0051 F4CC              ;
0052 F4CC              ;        Find last entry in linked list
0053 F4CC              ;
0054 F4CC              ;        Starting from First Entry, move from Entry to Entry until
0055 F4CC              ;        a Entry is found whose Next Entry Handle is NIL.  Put the
0056 F4CC              ;        Handle to each Entry back on the stack replacing the one
0057 F4CC              ;        before.
0058 F4CC              ;
0059 F4CC A3 09        loop     lda   First_Entry+2,s          ;Handle of First Entry
0060 F4CE A8                    tay   
0061 F4CF A3 07                 lda   First_Entry,s
0062 F4D1 20 D6 FA              jsr   DeRef                    ;dereference Handle
0063 F4D4 5A                    phy                            ;Pointer on stack
0064 F4D5 48                    pha   
0065 F4D6 20 D6 FA              jsr   DeRef                    ;get Next Entry Handle from First Entry
0066 F4D9 5A                    phy                            ;save on stack
0067 F4DA 48                    pha   
0068 F4DB 03 03                 ora   3,s                      ;is Next Entry Handle NIL?
0069 F4DD F0 0D                 beq   last                     ;yes, found last Entry
0070 F4DF A3 01                 lda   1,s                      ;replace Handle to First Entry with
0071 F4E1 83 0F                 sta   First_Entry+8,s          ;  Next Entry Handle in First Entry
0072 F4E3 98                    tya   
0073 F4E4 83 11                 sta   First_Entry+10,s
0074 F4E6 68                    pla                            ;clean up stack
0075 F4E7 68                    pla   
0076 F4E8 68                    pla   
0077 F4E9 68                    pla   
0078 F4EA 80 E0                 bra   loop                     ;repeat logic
0079 F4EC              ;
0080 F4EC              ;        Last Entry in linked list has been found.  Handle to First Entry
0081 F4EC              ;        on stack is now Handle to Last Entry. Pointer to Last Entry is
0082 F4EC              ;        on TOS+5.
0083 F4EC              ;
0084 F4EC 68           last     pla                            ;remove NIL Handle
0085 F4ED 68                    pla   
0086 F4EE 68                    pla                            ;pull Pointer to Last Entry
0087 F4EF 7A                    ply   
0088 F4F0 8B                    phb                            ;save DBR
0089 F4F1 20 CF FA              jsr   UsePtr                   ;make Pointer usable
0090 F4F4 A3 06                 lda   New_Entry+3,s            ;store Handle to New Entry
0091 F4F6 A8                    tay   
0092 F4F7 9D 02 00              sta   |2,x                     ;  as Next Entry Handle of Last Entry
0093 F4FA A3 04                 lda   New_Entry+1,s
0094 F4FC 9D 00 00              sta   |0,x
0095 F4FF AB                    plb                            ;restore DBR
0096 F500 20 D6 FA              jsr   DeRef                    ;dereference handle
0097 F503 8B                    phb                            ;save DBR
0098 F504 20 CF FA              jsr   UsePtr                   ;make Pointer to New Entry usable
0099 F507 A3 08                 lda   First_Entry+1,s          ;store Handle to Last Entry
0100 F509 9D 04 00              sta   |4,x                     ;  in New Entry
0101 F50C A3 0A                 lda   First_Entry+3,s
0102 F50E 9D 06 00              sta   |6,x
0103 F511 AB                    plb                            ;restore DBR
0104 F512 A8 68 83 07  done     Stack_Cleanup 8                ;remove parameters
0105 F520 60                    rts                            ;return
0106 F521
0107 F521                       ENDP 
0108 F521
0109 F521                       TITLE ', STRUCT.a - Remove_Link'
0110 F521              *
0111 F521              ****************************************************************
0112 F521              *
0113 F521              *              Remove entry in Linked List
0114 F521              *
0115 F521              *  Inputs:     Address of Linked List          (TOS+7)
0116 F521              *              Handle of Entry                 (TOS+3)
0117 F521              *
0118 F521              *  Outputs:    none
0119 F521              *
0120 F521              *  Zero Page used: none
0121 F521              *
0122 F521              *        This routine assumes that the Linked List is in Bank 1
0123 F521              *        (e.g. in Loader's Global area)
0124 F521              *
0125 F521              ****************************************************************
0126 F521              *
0127 F521
0128 F521              Remove_Link PROC 
0129 F521                       with DirectPage
0130 F521
0131 F521              Address  equ   7+8
0132 F521              Entry    equ   3+8
0133 F521              Next     equ   5
0134 F521              Previous equ   1
0135 F521              ;
0136 F521              ;        get Previous handle and Next handle out of Entry
0137 F521              ;        and put on stack
0138 F521              ;
0139 F521 A3 05                 lda   Entry-6,s                ;handle of Entry
0140 F523 A8                    tay   
0141 F524 A3 03                 lda   Entry-8,s
0142 F526 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0143 F529 BD 02 00              lda   |2,x                     ;Next handle
0144 F52C 48                    pha   
0145 F52D BD 00 00              lda   |0,x
0146 F530 48                    pha   
0147 F531 BD 06 00              lda   |6,x                     ;Previous handle
0148 F534 48                    pha   
0149 F535 BD 04 00              lda   |4,x
0150 F538 48                    pha   
0151 F539              ;
0152 F539              ;        is Entry only one in linked list ?
0153 F539              ;        (Previous handle = Next handle = 0)
0154 F539              ;
0155 F539 03 01                 ora   Previous,s
0156 F53B A8                    tay                            ;save
0157 F53C 03 05                 ora   Next,s
0158 F53E 03 07                 ora   Next+2,s
0159 F540 D0 11                 bne   cont1
0160 F542              ;
0161 F542              ;        yes, zero out Address of Linked List
0162 F542              ;
0163 F542 4B                    phk                            ;restore DBR
0164 F543 AB                    plb   
0165 F544 A9 00 00              lda   #0
0166 F547 A0 00 00              ldy   #0
0167 F54A 93 0F                 sta   (Address,s),y
0168 F54C A0 02 00              ldy   #2
0169 F54F 93 0F                 sta   (Address,s),y
0170 F551 80 3F                 bra   cont4
0171 F553              ;
0172 F553              ;        no, is Previous handle of Entry = 0 (i.e. first entry) ?
0173 F553              ;
0174 F553 98           cont1    tya   
0175 F554 D0 12                 bne   cont2
0176 F556              ;
0177 F556              ;        yes, store Next handle of Entry in Address of Linked List
0178 F556              ;
0179 F556 4B                    phk                            ;restore DBR
0180 F557 AB                    plb   
0181 F558 A3 05                 lda   Next,s
0182 F55A A0 00 00              ldy   #0
0183 F55D 93 0F                 sta   (Address,s),y
0184 F55F A3 07                 lda   Next+2,s
0185 F561 A0 02 00              ldy   #2
0186 F564 93 0F                 sta   (Address,s),y
0187 F566 80 12                 bra   cont3
0188 F568              ;
0189 F568              ;        no, point to previous entry
0190 F568              ;
0191 F568 A3 03        cont2    lda   Previous+2,s
0192 F56A A8                    tay   
0193 F56B A3 01                 lda   Previous,s
0194 F56D 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0195 F570              ;
0196 F570              ;        set Next handle of previous entry to Next handle of Entry
0197 F570              ;
0198 F570 A3 05                 lda   Next,s
0199 F572 9D 00 00              sta   |0,x
0200 F575 A3 07                 lda   Next+2,s
0201 F577 9D 02 00              sta   |2,x
0202 F57A              ;
0203 F57A              ;        is Next handle of Entry = 0 (i.e. last entry) ?
0204 F57A              ;
0205 F57A A3 05        cont3    lda   Next,s
0206 F57C 03 07                 ora   Next+2,s
0207 F57E F0 12                 beq   cont4
0208 F580              ;
0209 F580              ;        no, point to next entry
0210 F580              ;
0211 F580 A3 07                 lda   Next+2,s
0212 F582 A8                    tay   
0213 F583 A3 05                 lda   Next,s
0214 F585 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0215 F588              ;
0216 F588              ;        set Previous handle of next entry to Previous handle of Entry
0217 F588              ;
0218 F588 A3 01                 lda   Previous,s
0219 F58A 9D 04 00              sta   |4,x
0220 F58D A3 03                 lda   Previous+2,s
0221 F58F 9D 06 00              sta   |6,x
0222 F592              ;
0223 F592              ;        dispose of Entry
0224 F592              ;
0225 F592 A3 0D        cont4    lda   Entry+2,s
0226 F594 48                    pha   
0227 F595 A3 0D                 lda   Entry+2,s
0228 F597 48                    pha   
0229 F598 A2 02 10 22           _DisposeHandle 
0230 F59F              ;
0231 F59F              ;        remove extra handles from stack
0232 F59F              ;
0233 F59F 68                    pla   
0234 F5A0 68                    pla   
0235 F5A1 68                    pla   
0236 F5A2 68                    pla   
0237 F5A3              ;
0238 F5A3              ;        restore DBR and stack
0239 F5A3              ;
0240 F5A3 4B                    phk                            ;set DBR to PBR
0241 F5A4 AB                    plb   
0242 F5A5 A8 68 83 07           Stack_Cleanup 8
0243 F5B3 60                    rts   
0244 F5B4
0245 F5B4                       ENDP 
0246 F5B4
0247 F5B4                       TITLE ', STRUCT.a - Add_Pathname'
0248 F5B4              *
0249 F5B4              ****************************************************************
0250 F5B4              *
0251 F5B4              *        Add new entry in Pathname Table
0252 F5B4              *
0253 F5B4              *  Inputs:      UserID                  (TOS+25)
0254 F5B4              *               File    Number          (TOS+23)
0255 F5B4              *               Time/Date Stamp         (TOS+15)
0256 F5B4              *               Direct Page/Stack Addr  (TOS+13)
0257 F5B4              *               Direct Page/Stack Size  (TOS+11)
0258 F5B4              *               Starting Address        (TOS+7)
0259 F5B4              *               Address of Pathname     (TOS+3)
0260 F5B4              *
0261 F5B4              *  Outputs:    New entry linked to last entry (if previous exists)
0262 F5B4              *              A - status code
0263 F5B4              *              C - set if error
0264 F5B4              *
0265 F5B4              *  Zero Page used: Pointer, Handle, TempZero
0266 F5B4              *
0267 F5B4              ****************************************************************
0268 F5B4              *
0269 F5B4
0270 F5B4              Add_Pathname PROC 
0271 F5B4                       with DirectPage, Globals
0272 F5B4
0273 F5B4              IUserID  EQU   25
0274 F5B4              FileNum  EQU   23
0275 F5B4              Date     EQU   15
0276 F5B4              ZP_Addr  EQU   13
0277 F5B4              ZP_Size  EQU   11
0278 F5B4              Address  EQU   7
0279 F5B4              PathName EQU   3
0280 F5B4
0281 F5B4              APathTbl equ   Pointer
0282 F5B4
0283 F5B4 A3 03                 lda   PathName,s
0284 F5B6 85 00                 sta   TempZero                 ;store addr of Pathname in zero page
0285 F5B8 A3 05                 lda   PathName+2,s
0286 F5BA 85 02                 sta   TempZero+2
0287 F5BC              ;
0288 F5BC              ;        get a memory buffer for new entry
0289 F5BC              ;
0290 F5BC A2 00 00              ldx   #0
0291 F5BF DA                    phx                            ;space for output Handle
0292 F5C0 DA                    phx   
0293 F5C1 DA                    phx                            ;BlockSize =
0294 F5C2 A7 00                 lda   [TempZero]               ;    length of File Name
0295 F5C4 18                    clc   
0296 F5C5 69 20 00              adc   #PT_Path+2               ;   +size of constant portion
0297 F5C8 48                    pha   
0298 F5C9 F4 04 70              pea   uPATHTBL                 ;Owner
0299 F5CC F4 08 00              pea   attrNoSpec               ;Attributes
0300 F5CF DA                    phx                            ;Location
0301 F5D0 DA                    phx   
0302 F5D1
0303 F5D1 A2 02 09 22           _NewHandle                     ;get memory buffer
0304 F5D8
0305 F5D8 FA                    plx   
0306 F5D9 7A                    ply   
0307 F5DA 86 08                 stx   Handle                   ;save returned handle
0308 F5DC 84 0A                 sty   Handle+2
0309 F5DE 90 03                 bcc   @1
0310 F5E0 4C 6C F6              jmp   error
0311 F5E3              @1        
0312 F5E3 8A                    txa   
0313 F5E4 20 D6 FA              jsr   DeRef                    ;dereference handle
0314 F5E7 85 10                 sta   APathTbl                 ;save address of entry
0315 F5E9 84 12                 sty   APathTbl+2
0316 F5EB              ;
0317 F5EB              ;        zero linked list pointers
0318 F5EB              ;
0319 F5EB A9 00 00              lda   #0
0320 F5EE A0 06 00              ldy   #6
0321 F5F1              @loop     
0322 F5F1 97 10                 sta   [APathTbl],y
0323 F5F3 88                    dey   
0324 F5F4 88                    dey   
0325 F5F5 10 FA                 bpl   @loop
0326 F5F7              ;
0327 F5F7              ;        set DBR to address of entry
0328 F5F7              ;
0329 F5F7 A5 10                 lda   APathTbl
0330 F5F9 A4 12                 ldy   APathTbl+2
0331 F5FB 8B                    phb                            ;save DBR
0332 F5FC 20 CF FA              jsr   UsePtr
0333 F5FF              ;
0334 F5FF              ;        store UserID in new entry
0335 F5FF              ;
0336 F5FF A3 1A                 lda   IUserID+1,s
0337 F601 9D 08 00              sta   |PT_UserID,x
0338 F604              ;
0339 F604              ;        store File Number in new entry
0340 F604              ;
0341 F604 A3 18                 lda   FileNum+1,s
0342 F606 9D 0A 00              sta   |PT_FileNum,x
0343 F609              ;
0344 F609              ;        if File Number=1, set Jump Table Segment processed flag to 1
0345 F609              ;        otherwise, zero it
0346 F609              ;
0347 F609 C9 01 00              cmp   #1
0348 F60C F0 03                 beq   cont
0349 F60E A9 00 00              lda   #0
0350 F611 9D 18 00     cont     sta   |PT_Jump,x
0351 F614              ;
0352 F614              ;        store File Date and Time in new entry
0353 F614              ;
0354 F614 A3 10                 lda   Date+1,s
0355 F616 9D 0C 00              sta   |PT_Date,x
0356 F619 A3 12                 lda   Date+3,s
0357 F61B 9D 0E 00              sta   |PT_Date+2,x
0358 F61E A3 14                 lda   Date+5,s
0359 F620 9D 10 00              sta   |PT_Date+4,x
0360 F623 A3 16                 lda   Date+7,s
0361 F625 9D 12 00              sta   |PT_Date+6,x
0362 F628              ;
0363 F628              ;        store Zero Page/Stack info in new entry
0364 F628              ;
0365 F628 A3 0E                 lda   ZP_Addr+1,s
0366 F62A 9D 14 00              sta   |PT_ZP_Addr,x
0367 F62D A3 0C                 lda   ZP_Size+1,s
0368 F62F 9D 16 00              sta   |PT_ZP_Size,x
0369 F632              ;
0370 F632              ;       store Starting Address in new entry
0371 F632              ;
0372 F632 A3 08                 lda   Address+1,s
0373 F634 9D 1A 00              sta   |PT_Address,x
0374 F637 A3 0A                 lda   Address+3,s
0375 F639 9D 1C 00              sta   |PT_Address+2,x
0376 F63C              ;
0377 F63C              ;        restore DBR
0378 F63C              ;
0379 F63C AB                    plb   
0380 F63D              ;
0381 F63D              ;        move File Name into Pathname
0382 F63D              ;
0383 F63D D4 02                 pei   TempZero+2               ;source address
0384 F63F D4 00                 pei   TempZero
0385 F641 A5 10                 lda   APathTbl                 ;calculate destination address
0386 F643 18                    clc   
0387 F644 69 1E 00              adc   #PT_Path
0388 F647 AA                    tax   
0389 F648 A5 12                 lda   APathTbl+2
0390 F64A 69 00 00              adc   #^PT_Path
0391 F64D 48                    pha   
0392 F64E DA                    phx                            ;destination address
0393 F64F F4 00 00              pea   0                        ;number of bytes
0394 F652 A7 00                 lda   [TempZero]
0395 F654 18                    clc   
0396 F655 69 02 00              adc   #2
0397 F658 48                    pha   
0398 F659
0399 F659 20 EE F9              jsr   Block_Move               ;call Move function
0400 F65C              ;
0401 F65C              ;        link new Pathname Table to previous
0402 F65C              ;
0403 F65C F4 01 00              pea   PATHTBL>>16
0404 F65F F4 B2 A6              pea   |PATHTBL
0405 F662 D4 0A                 pei   Handle+2
0406 F664 D4 08                 pei   Handle
0407 F666 20 A8 F4              jsr   Add_Link
0408 F669              ;
0409 F669              ;        return
0410 F669              ;
0411 F669 A9 00 00     return   lda   #0
0412 F66C A8 68 83 17  error    Stack_Cleanup 24               ;remove input parameters
0413 F67A 60                    rts   
0414 F67B
0415 F67B                       ENDP 
0416 F67B
0417 F67B                       TITLE ', STRUCT.a - Find_Pathname'
0418 F67B              *
0419 F67B              ****************************************************************
0420 F67B              *
0421 F67B              *        Find entry in Pathname Table
0422 F67B              *
0423 F67B              *  Inputs:      UserID                      (TOS+9)
0424 F67B              *               File Number                 (TOS+7)
0425 F67B              *               Address of Pathname         (TOS+3)
0426 F67B              *
0427 F67B              *  Outputs:    none
0428 F67B              *              X - low bytes of Pointer to entry
0429 F67B              *              DBR - bank
0430 F67B              *              Handle- Handle of entry
0431 F67B              *              A - status code
0432 F67B              *              C - set if error
0433 F67B              *              Counter - if no find, contains max File Number
0434 F67B              *
0435 F67B              *  Zero Page used: Handle, TempZero, Counter
0436 F67B              *
0437 F67B              *       This routine will search the Pathname Table for an entry that satisfies
0438 F67B              *       each of the input parameters.   If a parameter is 0, it is not used as
0439 F67B              *       a criteria.  If no such entry is found, Counter will contain the max
0440 F67B              *       File Number encountered (which is only useful if a UserID is specified)
0441 F67B              *
0442 F67B              *       Before  calling this routine, the User should save the DBR.
0443 F67B              *
0444 F67B              *       After calling this  routine and making all references to the entry,
0445 F67B              *       the User must restore the original  DBR.
0446 F67B              *
0447 F67B              *       This routine can also be used to walk through the Pathname Table
0448 F67B              *       by  calling the 'Find_Pathname' entry once and then calling the
0449 F67B              *       'Next_Pathname' entry for each subsequent entry.  The Direct Page variable
0450 F67B              *       'Handle' will point to  the handle of the current entry so it should be
0451 F67B              *       bumped to the handle of the next entry between 'Next_Pathname' calls.
0452 F67B              *
0453 F67B              ****************************************************************
0454 F67B              *
0455 F67B
0456 F67B              Find_Pathname PROC 
0457 F67B                       with DirectPage, Globals
0458 F67B
0459 F67B              IUserID  EQU   9
0460 F67B              FileNum  EQU   7
0461 F67B              Path     EQU   3
0462 F67B
0463 F67B AD B2 A6              lda   |PATHTBL
0464 F67E 85 08                 sta   Handle                   ;handle to 1st entry
0465 F680 AD B4 A6              lda   |PATHTBL+2
0466 F683 85 0A                 sta   Handle+2
0467 F685 64 14                 stz   Counter
0468 F687
0469 F687                       ENTRY Next_Pathname
0470 F687              Next_Pathname  
0471 F687
0472 F687 A5 08        loop1    lda   Handle                   ;is handle 0?
0473 F689 05 0A                 ora   Handle+2
0474 F68B D0 08                 bne   cont1
0475 F68D A9 01 11              lda   #NoFind                  ;yes, No Find error
0476 F690 4B                    phk                            ;set DBR to PBR
0477 F691 AB                    plb   
0478 F692 4C FE F6              jmp   error
0479 F695
0480 F695 A5 08        cont1    lda   Handle
0481 F697 A4 0A                 ldy   Handle+2
0482 F699 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0483 F69C              ;
0484 F69C              ;       if  input UserID<>0, compare with value in entry
0485 F69C              ;
0486 F69C A3 09                 lda   IUserID,s
0487 F69E F0 05                 beq   cont2
0488 F6A0 DD 08 00              cmp   |PT_UserID,x
0489 F6A3 D0 3C                 bne   eloop2
0490 F6A5              ;
0491 F6A5              ;       if  input File Number<>0, compare with value in entry
0492 F6A5              ;
0493 F6A5 A3 07        cont2    lda   FileNum,s
0494 F6A7 F0 05                 beq   cont5
0495 F6A9 DD 0A 00              cmp   |PT_FileNum,x
0496 F6AC D0 33                 bne   eloop2
0497 F6AE              ;
0498 F6AE              ;       if  pathname specified, compare with pathname in entry
0499 F6AE              ;
0500 F6AE A3 03        cont5    lda   Path,s
0501 F6B0 03 05                 ora   Path+2,s
0502 F6B2 F0 45                 beq   return                   ;found match, done
0503 F6B4 A3 03                 lda   Path,s
0504 F6B6 85 00                 sta   TempZero
0505 F6B8 A3 05                 lda   Path+2,s
0506 F6BA 85 02                 sta   TempZero+2
0507 F6BC 8A                    txa   
0508 F6BD 18                    clc   
0509 F6BE 69 1E 00              adc   #PT_Path
0510 F6C1 85 04                 sta   TempZero+4
0511 F6C3 8B                    phb   
0512 F6C4 8B                    phb   
0513 F6C5 68                    pla   
0514 F6C6 29 FF 00              and   #$00FF
0515 F6C9 90 01                 bcc   @1                       ;propage carry for possible
0516 F6CB 1A                    inc   a                        ;bank crossing
0517 F6CC              @1        
0518 F6CC 85 06                 sta   TempZero+6
0519 F6CE A7 00                 lda   [TempZero]
0520 F6D0 1A                    inc   a
0521 F6D1 A8                    tay   
0522 F6D2 E2 20                 sep   #$20
0523 F6D4                       longa off
0524 F6D4 B7 00        loop2    lda   [TempZero],y
0525 F6D6 57 04                 eor   [TempZero+4],y           ;case insensitive comparison
0526 F6D8 29 DF                 and   #$DF                     ;ignore the case bit
0527 F6DA D0 05                 bne   eloop2
0528 F6DC 88                    dey   
0529 F6DD 10 F5                 bpl   loop2
0530 F6DF 80 18                 bra   return                   ;matches
0531 F6E1
0532 F6E1 C2 20        eloop2   rep   #$20
0533 F6E3                       longa on
0534 F6E3              ;
0535 F6E3              ;        set Counter=max(Counter,File Number)
0536 F6E3              ;
0537 F6E3 BD 0A 00              lda   |PT_FileNum,x
0538 F6E6 C5 14                 cmp   Counter
0539 F6E8 90 02                 bcc   eloop1
0540 F6EA 85 14                 sta   Counter
0541 F6EC              ;
0542 F6EC              ;        continue to next entry
0543 F6EC              ;
0544 F6EC BD 00 00     eloop1   lda   |PT_Next,x
0545 F6EF 85 08                 sta   Handle                   ;bump Handle to Next Handle
0546 F6F1 BD 02 00              lda   |PT_Next+2,x
0547 F6F4 85 0A                 sta   Handle+2
0548 F6F6
0549 F6F6 4C 87 F6              jmp   loop1                    ;continue checking
0550 F6F9              ;
0551 F6F9              ;        normal return
0552 F6F9              ;
0553 F6F9 C2 20        return   rep   #$20
0554 F6FB                       longa on
0555 F6FB A9 00 00              lda   #0                       ;OK return
0556 F6FE A8 68 83 07  error    Stack_Cleanup 8                ;remove input parameters
0557 F70C 60                    rts   
0558 F70D
0559 F70D                       ENDP 
0560 F70D
0561 F70D                       TITLE ', STRUCT.a - Get_Pathname'
0562 F70D              *
0563 F70D              ****************************************************************
0564 F70D              *
0565 F70D              *              Get Pathname
0566 F70D              *
0567 F70D              *  Inputs:     Handle - Handle  to Pathname Table entry
0568 F70D              *
0569 F70D              *  Outputs:    TempBuff - Address of temporary buffer containing pathname
0570 F70D              *              A - status
0571 F70D              *              C - set if error occurred
0572 F70D              *
0573 F70D              *  Zero Page used: Pointer
0574 F70D              *
0575 F70D              *        The pathname in the Pathname Table entry is moved into
0576 F70D              *        a temporary buffer.  This buffer should be disposed after
0577 F70D              *        the pathname is used.
0578 F70D              *
0579 F70D              ****************************************************************
0580 F70D              *
0581 F70D
0582 F70D              Get_Pathname PROC 
0583 F70D                       with DirectPage
0584 F70D              ;
0585 F70D              ;       lock input handle
0586 F70D              ;
0587 F70D D4 0A                 pei   Handle+2
0588 F70F D4 08                 pei   Handle
0589 F711 A2 02 20 22           _HLock 
0590 F718              ;
0591 F718              ;        set Pointer to address of pathname using Handle to entry
0592 F718              ;
0593 F718 A5 08                 lda   Handle
0594 F71A A4 0A                 ldy   Handle+2
0595 F71C 20 D6 FA              jsr   DeRef
0596 F71F 18                    clc   
0597 F720 69 1E 00              adc   #PT_Path
0598 F723 85 10                 sta   Pointer
0599 F725 90 01                 bcc   @1
0600 F727 C8                    iny   
0601 F728 84 12        @1       sty   Pointer+2
0602 F72A              ;
0603 F72A              ;        extract length of pathname and save
0604 F72A              ;
0605 F72A A7 10                 lda   [Pointer]
0606 F72C 1A                    inc   a
0607 F72D 1A                    inc   a
0608 F72E 48                    pha   
0609 F72F              ;
0610 F72F              ;        get a temporary buffer
0611 F72F              ;
0612 F72F 20 C7 F9              jsr   Get_TempBuff
0613 F732              ;
0614 F732              ;       unlock input handle
0615 F732              ;
0616 F732 D4 0A                 pei   Handle+2
0617 F734 D4 08                 pei   Handle
0618 F736 A2 02 22 22           _HUnlock 
0619 F73D              ;
0620 F73D              ;        unsave length of pathname
0621 F73D              ;
0622 F73D FA                    plx   
0623 F73E              ;
0624 F73E              ;        copy pathname to temporary buffer
0625 F73E              ;
0626 F73E D4 12                 pei   Pointer+2                ;Source
0627 F740 D4 10                 pei   Pointer
0628 F742 D4 1A                 pei   TempBuff+2               ;Destination
0629 F744 D4 18                 pei   TempBuff
0630 F746 F4 00 00              pea   0
0631 F749 DA                    phx                            ;Size
0632 F74A
0633 F74A 20 EE F9              jsr   Block_Move
0634 F74D
0635 F74D 60           error    rts   
0636 F74E
0637 F74E                       ENDP 
0638 F74E
0639 F74E                       TITLE ', STRUCT.a - Convert_Pathname'
0640 F74E              *
0641 F74E              ****************************************************************
0642 F74E              *
0643 F74E              *              Convert Pathname
0644 F74E              *
0645 F74E              *  Inputs:     A,Y - Address of Pathname
0646 F74E              *              X - pathname conversion code (0-Type 0 to 1)
0647 F74E              *                                           (1-Type 1 to 0)
0648 F74E              *
0649 F74E              *  Outputs:    TempBuff - Address of converted pathname
0650 F74E              *              A - status
0651 F74E              *              C - set if error occurred
0652 F74E              *
0653 F74E              *  Zero Page used: TempZero
0654 F74E              *
0655 F74E              *        A temporary buffer is allocated for the converted pathname and
0656 F74E              *        should be disposed after the pathname is used.  Use the DisposeAll
0657 F74E              *        function with UserID 'uTempBuff' to dispose of the temporary buffer.
0658 F74E              *
0659 F74E              ****************************************************************
0660 F74E              *
0661 F74E
0662 F74E              Convert_Pathname PROC  
0663 F74E                       with DirectPage
0664 F74E              ;
0665 F74E              ;        save inputs in direct page
0666 F74E              ;
0667 F74E 85 00                 sta   TempZero
0668 F750 84 02                 sty   TempZero+2
0669 F752 86 04                 stx   TempZero+4
0670 F754              ;
0671 F754              ;        calculated converted pathname size
0672 F754              ;
0673 F754 A7 00                 lda   [TempZero]
0674 F756 1A                    inc   a
0675 F757 CA                    dex                            ;if class 0 string, use 1st byte
0676 F758 F0 04                 beq   cont1                    ;if class 1 string, use word
0677 F75A 29 FF 00              and   #$00FF
0678 F75D 1A                    inc   a
0679 F75E              ;
0680 F75E              ;        get temporary buffer for full pathname
0681 F75E              ;
0682 F75E 20 C7 F9     cont1    jsr   Get_TempBuff
0683 F761 D4 02                 pei   TempZero+2
0684 F763 D4 00                 pei   TempZero
0685 F765 D4 1A                 pei   TempBuff+2
0686 F767 D4 18                 pei   TempBuff
0687 F769              ;
0688 F769              ;        check conversion code
0689 F769              ;
0690 F769 A6 04                 ldx   TempZero+4
0691 F76B CA                    dex   
0692 F76C F0 08                 beq   cont2
0693 F76E              ;
0694 F76E              ;        class 0 to 1 requested, call GS/OS Convert 0 routine
0695 F76E              ;
0696 F76E 22 74 FC 01           jsl   CVT_0TO1
0697 F772 90 21                 bcc   return
0698 F774 80 1C                 bra   error
0699 F776              ;
0700 F776              ;        class 1 to 0 requested, call GS/OS Convert 1 to 0 routine
0701 F776              ;
0702 F776 22 78 FC 01  cont2    jsl   CVT_1TO0
0703 F77A B0 16                 bcs   error
0704 F77C              ;
0705 F77C              ;        replace the :'s in the pathname with /'s
0706 F77C              ;
0707 F77C A7 00                 lda   [TempZero]
0708 F77E A8                    tay   
0709 F77F E2 30                 sep   #$30
0710 F781                       longa off
0711 F781                       longi off
0712 F781 B7 18        loop     lda   [TempBuff],y
0713 F783 C9 3A                 cmp   #':'
0714 F785 D0 04                 bne   eloop
0715 F787 A9 2F                 lda   #'/'
0716 F789 97 18                 sta   [TempBuff],y
0717 F78B 88           eloop    dey   
0718 F78C D0 F3                 bne   loop
0719 F78E C2 30                 rep   #$30
0720 F790                       longa on
0721 F790                       longi on
0722 F790 98                    tya                            ;zeroize accumulator (no error)
0723 F791 60                    rts   
0724 F792
0725 F792 A9 03 11     error    lda   #BadPath
0726 F795 60           return   rts   
0727 F796
0728 F796                       ENDP 
0729 F796
0730 F796                       TITLE ', STRUCT.a - Expand_Pathname'
0731 F796              *
0732 F796              ****************************************************************
0733 F796              *
0734 F796              *              Expand Pathname
0735 F796              *
0736 F796              *  Inputs:     A,Y - Address of Partial Pathname
0737 F796              *
0738 F796              *  Outputs:    TempBuff - Address of full pathname
0739 F796              *              A - status
0740 F796              *              C - set if error occurred
0741 F796              *
0742 F796              *  Zero Page used: TempZero, Counter
0743 F796              *
0744 F796              *        A temporary buffer is allocated for the full pathname and should be
0745 F796              *        disposed after the pathname is used.  Use the DisposeAll function
0746 F796              *        with UserID 'uTempBuff' to dispose of the temporary buffer.
0747 F796              *
0748 F796              ****************************************************************
0749 F796              *
0750 F796
0751 F796              Expand_Pathname PROC 
0752 F796                       with DirectPage, Globals
0753 F796              ;
0754 F796              ;       save address of partial pathname
0755 F796              ;
0756 F796 85 00                 sta   TempZero
0757 F798 84 02                 sty   TempZero+2
0758 F79A              ;
0759 F79A              ;       setup Expand_Path packet
0760 F79A              ;
0761 F79A 8D 68 A7              sta   |PExpandPath.inputPath   ;input partial pathname
0762 F79D 8C 6A A7              sty   |PExpandPath.inputPath+2
0763 F7A0 A9 03 00              lda   #3
0764 F7A3 8D 66 A7              sta   |PExpandPath.pCount      ;parameter count
0765 F7A6              ;	lda	#$8000
0766 F7A6              ;	sta	|PExpandPath.flags	;uppercase flag
0767 F7A6 9C 70 A7              stz   |PExpandPath.flags       ;uppercase flag (no uppercasing)
0768 F7A9              ;
0769 F7A9              ;       get length  of partial pathname
0770 F7A9              ;
0771 F7A9 A7 00                 lda   [TempZero]
0772 F7AB              ;
0773 F7AB              ;       calculate initial buffer size = length  of partial pathname +4
0774 F7AB              ;
0775 F7AB 18           cont2    clc   
0776 F7AC 69 04 00              adc   #4
0777 F7AF 85 14                 sta   Counter
0778 F7B1              ;
0779 F7B1              ;       get temporary buffer for full pathname
0780 F7B1              ;
0781 F7B1 20 C7 F9              jsr   Get_TempBuff
0782 F7B4              ;
0783 F7B4              ;       set length  of buffer in output string buffer
0784 F7B4              ;
0785 F7B4 A5 14                 lda   Counter
0786 F7B6 87 18                 sta   [TempBuff]
0787 F7B8              ;
0788 F7B8              ;       store address of buffer in  Expand_Path packet
0789 F7B8              ;
0790 F7B8 A5 18                 lda   TempBuff
0791 F7BA 8D 6C A7              sta   |PExpandPath.outputPath
0792 F7BD A5 1A                 lda   TempBuff+2
0793 F7BF 8D 6E A7              sta   |PExpandPath.outputPath+2
0794 F7C2              ;
0795 F7C2              ;           call GS/OS  Expand_Path
0796 F7C2              ;
0797 F7C2 22 A8 00 E1           jsl   $E100A8
0798 F7C6 0E 20                 DC W:ExpandPath
0799 F7C8 66 A7 01 00           DC L:PExpandPath
0800 F7CC              ;
0801 F7CC              ;       if  buffer too small, get needed size and try again
0802 F7CC              ;
0803 F7CC 90 1E                 bcc   cont5
0804 F7CE C9 4F 00              cmp   #buffTooSmall
0805 F7D1 D0 07                 bne   cont3
0806 F7D3 A0 02 00              ldy   #2
0807 F7D6 B7 18                 lda   [TempBuff],y
0808 F7D8 80 D1                 bra   cont2
0809 F7DA              ;
0810 F7DA              ;       if  GS/OS is active, that means that GS/OS called RenamePath and we can
0811 F7DA              ;       assume that the input filename is already expanded and in correct format
0812 F7DA              ;
0813 F7DA C9 07 00     cont3    cmp   #gsosActive
0814 F7DD F0 03                 beq   cont4
0815 F7DF 38                    sec                            ;any other GS/OS error is really an error
0816 F7E0 80 1A                 bra   error
0817 F7E2
0818 F7E2              cont4     
0819 F7E2 A5 00                 lda   TempZero
0820 F7E4 85 18                 sta   TempBuff
0821 F7E6 A5 02                 lda   TempZero+2
0822 F7E8 85 1A                 sta   TempBuff+2
0823 F7EA 80 0C                 bra   return
0824 F7EC              ;
0825 F7EC              ;       otherwise,  point TempBuff to start of pathname
0826 F7EC              ;
0827 F7EC A5 18        cont5    lda   TempBuff
0828 F7EE 18                    clc   
0829 F7EF 69 02 00              adc   #2
0830 F7F2 85 18                 sta   TempBuff
0831 F7F4 90 02                 bcc   return
0832 F7F6 E6 1A                 inc   TempBuff+2
0833 F7F8
0834 F7F8 A9 00 00     return   lda   #0
0835 F7FB 18                    clc   
0836 F7FC 60           error    rts   
0837 F7FD
0838 F7FD                       ENDP 
0839 F7FD
0840 F7FD                       TITLE ', STRUCT.a - Add_MemSeg'
0841 F7FD              *
0842 F7FD              ****************************************************************
0843 F7FD              *
0844 F7FD              *        Add entry to Memory Segment Table
0845 F7FD              *
0846 F7FD              *  Inputs:     Memory Handle                 (TOS+11)
0847 F7FD              *              User ID                       (TOS+9)
0848 F7FD              *              Load File Number              (TOS+7)
0849 F7FD              *              Load Segment Number           (TOS+5)
0850 F7FD              *              Load Segment Kind             (TOS+3)
0851 F7FD              *
0852 F7FD              *  Outputs:    New table linked to last table (if previous exists)
0853 F7FD              *              A - status code
0854 F7FD              *              C - set if error
0855 F7FD              *
0856 F7FD              *  Zero Page used: TempZero
0857 F7FD              *
0858 F7FD              ****************************************************************
0859 F7FD              *
0860 F7FD
0861 F7FD              Add_MemSeg PROC 
0862 F7FD                       with DirectPage, Globals
0863 F7FD
0864 F7FD              IHandle  equ   11
0865 F7FD              IUserID  equ   9
0866 F7FD              FileNum  equ   7
0867 F7FD              SegNum   equ   5
0868 F7FD              Kind     equ   3
0869 F7FD              ;
0870 F7FD              ;        get a memory buffer for new entry
0871 F7FD              ;
0872 F7FD A9 00 00              lda   #0                       ;space for output Handle
0873 F800 48                    pha   
0874 F801 48                    pha   
0875 F802 F4 00 00              pea   MS_Kind+2>>16            ;BlockSize
0876 F805 F4 14 00              pea   |MS_Kind+2
0877 F808 F4 03 70              pea   uSEGTBL                  ;Owner
0878 F80B F4 18 00              pea   attrNoCross+attrNoSpec   ;Attributes
0879 F80E 48                    pha                            ;Location
0880 F80F 48                    pha   
0881 F810
0882 F810 A2 02 09 22           _NewHandle                     ;get memory buffer
0883 F817
0884 F817 FA                    plx   
0885 F818 7A                    ply   
0886 F819 86 00                 stx   TempZero                 ;save returned handle
0887 F81B 84 02                 sty   TempZero+2
0888 F81D B0 40                 bcs   error
0889 F81F
0890 F81F 8A                    txa   
0891 F820 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0892 F823              ;
0893 F823              ;        store components into Memory Segment entry
0894 F823              ;
0895 F823 9E 00 00              stz   |MS_Next,x
0896 F826 9E 02 00              stz   |MS_Next+2,x
0897 F829 9E 04 00              stz   |MS_Prev,x
0898 F82C 9E 06 00              stz   |MS_Prev+2,x
0899 F82F A3 09                 lda   IUserID,s
0900 F831 9D 08 00              sta   |MS_UserID,x
0901 F834 A3 0B                 lda   IHandle,s
0902 F836 9D 0A 00              sta   |MS_Handle,x
0903 F839 A3 0D                 lda   IHandle+2,s
0904 F83B 9D 0C 00              sta   |MS_Handle+2,x
0905 F83E A3 07                 lda   FileNum,s
0906 F840 9D 0E 00              sta   |MS_FileNum,x
0907 F843 A3 05                 lda   SegNum,s
0908 F845 9D 10 00              sta   |MS_SegNum,x
0909 F848 A3 03                 lda   Kind,s
0910 F84A 9D 12 00              sta   |MS_Kind,x
0911 F84D
0912 F84D 4B                    phk                            ;restore DBR to PBR
0913 F84E AB                    plb   
0914 F84F              ;
0915 F84F              ;        link new entry to previous
0916 F84F              ;
0917 F84F F4 01 00              pea   SEGTBL>>16
0918 F852 F4 AA A6              pea   |SEGTBL
0919 F855 D4 02                 pei   TempZero+2
0920 F857 D4 00                 pei   TempZero
0921 F859 20 A8 F4              jsr   Add_Link
0922 F85C              ;
0923 F85C              ;        return
0924 F85C              ;
0925 F85C A9 00 00              lda   #0                       ;OK return
0926 F85F A8 68 83 0B  error    Stack_Cleanup 12               ;remove input parameters
0927 F86D 60                    rts   
0928 F86E
0929 F86E                       ENDP 
0930 F86E
0931 F86E                       TITLE ', STRUCT.a - Find_MemSeg'
0932 F86E              *
0933 F86E              ****************************************************************
0934 F86E              *
0935 F86E              *        Find entry in Memory Segment Table
0936 F86E              *
0937 F86E              *  Inputs:     User ID                       (TOS+7)
0938 F86E              *              Load File Number              (TOS+5)
0939 F86E              *              Load Segment Number           (TOS+3)
0940 F86E              *
0941 F86E              *  Outputs:    Handle of entry               (TOS+9)
0942 F86E              *              X - low bytes of Pointer to entry
0943 F86E              *              DBR - bank
0944 F86E              *              Handle - Handle of Next entry
0945 F86E              *              A - status code
0946 F86E              *              C - set if entry not found or error ocurred
0947 F86E              *
0948 F86E              *  Zero Page used: Handle
0949 F86E              *
0950 F86E              *        If any of the inputs are 0, no comparison is made for that field.
0951 F86E              *
0952 F86E              *        Be careful! The DBR will be changed by this routine and the
0953 F86E              *        calling program should restore its original DBR after referencing
0954 F86E              *        the data in the entry.
0955 F86E              *
0956 F86E              *        This routine can also be used to walk through the Memory Segment Table
0957 F86E              *        by calling the 'Find_MemSeg' entry once and then calling the
0958 F86E              *        'Next_MemSeg' entry for each subsequent entry.  The Direct Page variable
0959 F86E              *        'Handle' will point to the handle of the next entry so should not be
0960 F86E              *        changed between 'Next_MemSeg' calls.
0961 F86E              *
0962 F86E              ****************************************************************
0963 F86E              *
0964 F86E
0965 F86E              Find_MemSeg PROC 
0966 F86E                       with DirectPage, Globals
0967 F86E
0968 F86E              OHandle  equ   9
0969 F86E              IUserID  equ   7
0970 F86E              FileNum  equ   5
0971 F86E              SegNum   equ   3
0972 F86E
0973 F86E AF AA A6 01           lda   >SEGTBL
0974 F872 85 08                 sta   Handle                   ;handle to 1st entry
0975 F874 AF AC A6 01           lda   >SEGTBL+2
0976 F878 85 0A                 sta   Handle+2
0977 F87A
0978 F87A                       ENTRY Next_MemSeg
0979 F87A              Next_MemSeg  
0980 F87A
0981 F87A A5 08        loop     lda   Handle                   ;is handle NIL?
0982 F87C 05 0A                 ora   Handle+2
0983 F87E D0 05                 bne   cont1
0984 F880 A9 01 11              lda   #NoFind                  ;yes, No Find error
0985 F883 80 34                 bra   error
0986 F885
0987 F885 A5 0A        cont1    lda   Handle+2                 ;handle to entry
0988 F887 A8                    tay   
0989 F888 83 0B                 sta   OHandle+2,s              ;save as output
0990 F88A A5 08                 lda   Handle
0991 F88C 83 09                 sta   OHandle,s
0992 F88E 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
0993 F891 BD 00 00              lda   |MS_Next,x
0994 F894 85 08                 sta   Handle                   ;bump Handle to Next Handle
0995 F896 BD 02 00              lda   |MS_Next+2,x
0996 F899 85 0A                 sta   Handle+2
0997 F89B              ;
0998 F89B              ;        compare inputs with values in entry
0999 F89B              ;
1000 F89B A3 07                 lda   IUserID,s
1001 F89D F0 05                 beq   cont2
1002 F89F DD 08 00              cmp   |MS_UserID,x
1003 F8A2 D0 D6                 bne   loop
1004 F8A4 A3 05        cont2    lda   FileNum,s
1005 F8A6 F0 05                 beq   cont3
1006 F8A8 DD 0E 00              cmp   |MS_FileNum,x
1007 F8AB D0 CD                 bne   loop
1008 F8AD A3 03        cont3    lda   SegNum,s
1009 F8AF F0 05                 beq   return
1010 F8B1 DD 10 00              cmp   |MS_SegNum,x
1011 F8B4 D0 C4                 bne   loop
1012 F8B6              ;
1013 F8B6              ;        normal return
1014 F8B6              ;
1015 F8B6 A9 00 00     return   lda   #0                       ;OK return
1016 F8B9
1017 F8B9 A8 68 83 05  error    Stack_Cleanup 6                ;remove input parameters
1018 F8C7 60                    rts   
1019 F8C8
1020 F8C8                       ENDP 
1021 F8C8
1022 F8C8                       TITLE ', STRUCT.a - Remove_UserID'
1023 F8C8              *
1024 F8C8              ****************************************************************
1025 F8C8              *
1026 F8C8              *        Remove entries from Table
1027 F8C8              *
1028 F8C8              *  Inputs:     UserID                 (TOS+7)
1029 F8C8              *              Address of Linked List (TOS+3)
1030 F8C8              *
1031 F8C8              *  Outputs:    none
1032 F8C8              *
1033 F8C8              *  Zero Page used: Handle, TempZero
1034 F8C8              *
1035 F8C8              *        This routine can be used to remove entries from the
1036 F8C8              *        Pathname Table, Jump Table List and any other Table
1037 F8C8              *        that:
1038 F8C8              *
1039 F8C8              *        1.  is a linked list (with forward and back handles)
1040 F8C8              *        2.  first entry is UserID
1041 F8C8              *
1042 F8C8              ****************************************************************
1043 F8C8              *
1044 F8C8
1045 F8C8              Remove_UserID PROC 
1046 F8C8                       with DirectPage
1047 F8C8
1048 F8C8              IUserID  equ   7
1049 F8C8              Address  equ   3
1050 F8C8
1051 F8C8 A3 05                 lda   Address+2,s
1052 F8CA A8                    tay   
1053 F8CB A3 03                 lda   Address,s
1054 F8CD 20 D6 FA              jsr   DeRef
1055 F8D0 85 08                 sta   Handle                   ;handle to 1st entry
1056 F8D2 84 0A                 sty   Handle+2
1057 F8D4
1058 F8D4 05 0A        loop     ora   Handle+2
1059 F8D6 F0 30                 beq   return                   ;yes, finished
1060 F8D8 A5 08                 lda   Handle                   ;Y still has high word
1061 F8DA 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
1062 F8DD              ;
1063 F8DD              ;        save next Handle
1064 F8DD              ;
1065 F8DD BD 00 00              lda   |0,x
1066 F8E0 85 00                 sta   TempZero
1067 F8E2 BD 02 00              lda   |2,x
1068 F8E5 85 02                 sta   TempZero+2
1069 F8E7              ;
1070 F8E7              ;        check UserID
1071 F8E7              ;
1072 F8E7 BD 08 00              lda   |8,x
1073 F8EA 4B                    phk                            ;restore DBR
1074 F8EB AB                    plb   
1075 F8EC C3 07                 cmp   IUserID,s
1076 F8EE D0 0D                 bne   eloop
1077 F8F0              ;
1078 F8F0              ;        unlink this entry
1079 F8F0              ;
1080 F8F0 A3 05                 lda   Address+2,s              ;address of Pathname Table
1081 F8F2 48                    pha   
1082 F8F3 A3 05                 lda   Address+2,s
1083 F8F5 48                    pha   
1084 F8F6 D4 0A                 pei   Handle+2                 ;handle to this entry
1085 F8F8 D4 08                 pei   Handle
1086 F8FA 20 21 F5              jsr   Remove_Link
1087 F8FD              ;
1088 F8FD              ;        continue to next entry
1089 F8FD              ;
1090 F8FD A5 02        eloop    lda   TempZero+2
1091 F8FF 85 0A                 sta   Handle+2                 ;bump Handle to Next Handle
1092 F901 A8                    tay   
1093 F902 A5 00                 lda   TempZero
1094 F904 85 08                 sta   Handle
1095 F906 80 CC                 bra   loop
1096 F908              ;
1097 F908              ;        normal return
1098 F908              ;
1099 F908 4B           return   phk                            ;restore DBR
1100 F909 AB                    plb   
1101 F90A A8 68 83 05           Stack_Cleanup 6                ;remove input parameters
1102 F918 60                    rts   
1103 F919
1104 F919                       ENDP 
1105 F919
1106 F919                       TITLE ', STRUCT.a - Unload_JTL'
1107 F919              *
1108 F919              ****************************************************************
1109 F919              *
1110 F919              *              Unload Jump Table Entries
1111 F919              *
1112 F919              *  Inputs:     User ID                         (TOS+7)
1113 F919              *              Load File Number                (TOS+5)
1114 F919              *              Load Segment Number             (TOS+3)
1115 F919              *
1116 F919              *  Outputs:    none
1117 F919              *
1118 F919              *  Zero Page used: none
1119 F919              *
1120 F919              *              This subroutine will make all entries with the
1121 F919              *              specified components in the Jump Table unloaded.
1122 F919              *
1123 F919              *              If Load File Number or Load Segment Number is 0,
1124 F919              *              no comparison is made for that field
1125 F919              *
1126 F919              ****************************************************************
1127 F919              *
1128 F919
1129 F919              Unload_JTL PROC 
1130 F919                       with DirectPage, Globals
1131 F919
1132 F919              IUserID  equ   7+4
1133 F919              FileNum  equ   5+4
1134 F919              SegNum   equ   3+4
1135 F919              ;
1136 F919              ;        push 1st entry in Jump Table List
1137 F919              ;
1138 F919 AD B0 A6              lda   |JMPTBL+2
1139 F91C 48                    pha   
1140 F91D AD AE A6              lda   |JMPTBL
1141 F920 48                    pha   
1142 F921
1143 F921 03 03        loop1    ora   3,s                      ;is handle 0?
1144 F923 F0 68                 beq   return                   ;yes, we are finished
1145 F925 A3 03        cont1    lda   3,s                      ;no
1146 F927 A8                    tay   
1147 F928 A3 01                 lda   1,s
1148 F92A 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
1149 F92D              ;
1150 F92D              ;        is this Jump Table List entry for specified UserID?
1151 F92D              ;
1152 F92D BD 08 00              lda   |JT_UserID,x
1153 F930 C3 0B                 cmp   IUserID,s
1154 F932 D0 45                 bne   eloop1                   ;if not, skip this entry
1155 F934              ;
1156 F934              ;        find Jump Table
1157 F934              ;
1158 F934 BD 0A 00              lda   |JT_Handle,x
1159 F937 BC 0C 00              ldy   |JT_Handle+2,x
1160 F93A 20 D6 FA              jsr   DeRef                    ;dereference handle
1161 F93D B0 3A                 bcs   eloop1                   ;skip if handle is NIL
1162 F93F 20 CF FA              jsr   UsePtr                   ;make pointer useable
1163 F942              ;
1164 F942              ;        move X past 8 zero bytes to first entry in Jump Table
1165 F942              ;        (this will not be necessary when Linker changed)
1166 F942              ;
1167 F942 8A                    txa   
1168 F943 18                    clc   
1169 F944 69 08 00              adc   #8
1170 F947 AA                    tax   
1171 F948              ;
1172 F948              ;        compare inputs with values in entry
1173 F948              ;
1174 F948 BD 00 00     loop2    lda   |JE_UserID,x
1175 F94B F0 2C                 beq   eloop1                   ;if UserID=0, no more entries
1176 F94D C3 0B                 cmp   IUserID,s                ;redundant check for UserID
1177 F94F D0 20                 bne   eloop2
1178 F951 A3 09        cont2    lda   FileNum,s
1179 F953 F0 05                 beq   cont3
1180 F955 DD 02 00              cmp   |JE_FileNum,x
1181 F958 D0 17                 bne   eloop2
1182 F95A A3 07        cont3    lda   SegNum,s
1183 F95C F0 05                 beq   cont4
1184 F95E DD 04 00              cmp   |JE_SegNum,x
1185 F961 D0 0E                 bne   eloop2
1186 F963              ;
1187 F963              ;        entry satisfies input conditions, make unloaded
1188 F963              ;
1189 F963 AF AF A8 01  cont4    lda   >jump_load_instr         ;JSL instruction and 1st byte of address
1190 F967 9D 0A 00              sta   |JE_jsl,x
1191 F96A AF B1 A8 01           lda   >jump_load_instr+2       ;last two bytes of address
1192 F96E 9D 0C 00              sta   |JE_jsl+2,x
1193 F971              ;
1194 F971              ;        bump X to next entry
1195 F971              ;
1196 F971 8A           eloop2   txa   
1197 F972 18                    clc   
1198 F973 69 0E 00              adc   #JE_jsl+4
1199 F976 AA                    tax   
1200 F977 80 CF                 bra   loop2
1201 F979              ;
1202 F979              ;        bump Handle to next Jump Table List entry
1203 F979              ;
1204 F979 A3 03        eloop1   lda   3,s
1205 F97B A8                    tay   
1206 F97C A3 01                 lda   1,s
1207 F97E 20 C6 FA              jsr   DeRefUse                 ;dereference Handle and use Pointer
1208 F981 BD 02 00              lda   |JT_Next+2,x
1209 F984 83 03                 sta   3,s
1210 F986 BD 00 00              lda   |JT_Next,x               ;bump Handle to Next Handle
1211 F989 83 01                 sta   1,s
1212 F98B 80 94                 bra   loop1
1213 F98D
1214 F98D 68           return   pla                            ;pull last Handle off stack
1215 F98E 68                    pla   
1216 F98F A8 68 83 05           Stack_Cleanup 6                ;remove input parameters
1217 F99D 4B                    phk                            ;set DBR to PBR
1218 F99E AB                    plb   
1219 F99F 60                    rts   
1220 F9A0
1221 F9A0                       ENDP 
1222 F9A0
1223 F9A0                       TITLE ', STRUCT.a - Cleanup'
1224 F9A0              *
1225 F9A0              ****************************************************************
1226 F9A0              *
1227 F9A0              *              Cleanup Routine
1228 F9A0              *
1229 F9A0              *  Inputs:     UserID (2 bytes)         (TOS+3)
1230 F9A0              *
1231 F9A0              *  Outputs:    none
1232 F9A0              *
1233 F9A0              *  Zero Page used: TempZero, Handle
1234 F9A0              *
1235 F9A0              ****************************************************************
1236 F9A0              *
1237 F9A0
1238 F9A0              Cleanup  PROC 
1239 F9A0                       with DirectPage, Globals
1240 F9A0
1241 F9A0              IUserID  equ   3
1242 F9A0              ;
1243 F9A0              ;           if UserID is not 0, remove UserID from Jump Table first
1244 F9A0              ;
1245 F9A0 A3 03                 lda   IUserID,s
1246 F9A2 F0 0A                 beq   cont
1247 F9A4 48                    pha   
1248 F9A5 F4 01 00              pea   JMPTBL>>16
1249 F9A8 F4 AE A6              pea   |JMPTBL
1250 F9AB 20 C8 F8              jsr   Remove_UserID
1251 F9AE              ;
1252 F9AE A3 03        cont     lda   IUserID,s                ;UserID
1253 F9B0 48                    pha   
1254 F9B1 A2 00 00              ldx   #0                       ;Load File Number (all)
1255 F9B4 DA                    phx   
1256 F9B5 DA                    phx                            ;Load Segment Number (all)
1257 F9B6 DA                    phx                            ;Dynamic Only Flag (no)
1258 F9B7 DA                    phx                            ;Purge Level (real purge)
1259 F9B8 20 E6 EA              jsr   Purge_Segment
1260 F9BB
1261 F9BB A9 00 00     return   lda   #0                       ;OK return
1262 F9BE A8 68 83 01  error    Stack_Cleanup 2                ;remove input parameters
1263 F9C7                       rts   
1264 F9C7
1265 F9C7                       ENDP 
